﻿---
session_code: "BRK256"
title: "Enhance data security investigations with Microsoft Purview"
date: "2025-11-19"
speakers:
  - "Katerina Athanasiou"
  - "Christophe Fiessinger"
  - "Daniel Gawarecki"
  - "Caroline Lee"

products:
  - "Microsoft Ignite"

---

# Enhance data security investigations with Microsoft Purview
The presentation from Microsoft Ignite highlighted advancements in their security tools, focusing on enhancing data loss prevention and insider risk management through Defender and Purview. Here's a structured summary:

1. **Contextual Clarity During Incidents**: CISOs face pressure to provide context during active security incidents. This is crucial for enabling effective response by security teams.

2. **Integration of Tools**: Microsoft has integrated data loss prevention and insider risk management signals into Defender, adding Data Security Investigations (DSI) which allows initiating investigations directly from the incident queue. This provides a streamlined approach to addressing issues as they arise.

3. **Data Risk Graph**: The tool combines data governance and compliance signals with vulnerability and threat data, offering a visual representation that helps identify gaps in security posture and connects potential threats with sensitive data locations.

4. **Proactive Approach**: Teams are now more proactive in identifying sensitive data, reducing the likelihood of incidents by investigating potential risks before they escalate.

5. **User Experience and Learning**: Understanding and utilizing these tools effectively is emphasized through learning and proper scoping. This ensures that teams can maximize the tool's benefits without oversight.

6. **Scoping and Prioritization**: Proper scoping is essential, especially with large datasets, to ensure investigations are focused and impactful. The tool may prioritize issues based on sensitivity or risk level.

7. **Integration Ecosystem**: The tools integrate with other systems like Sentinel and Graph, enhancing visibility into potential threats and their impact on sensitive data.

8. **Adoption Considerations**: Implementing new tools requires consideration of user training and change management to ensure effective adoption and utilization across the organization.

In essence, these tools enhance security posture by automating parts of the investigation process, enabling faster and more informed responses to incidents, thereby better protecting sensitive data.
