﻿---
session_code: "BRK250"
title: "Preventing data exfiltration with a layered protection strategy"
date: "2025-11-20"
speakers:
  - "Vivian Ma"
  - "Shekhar Palta"
  - "Roberto Yglesias"

products:
  - "Microsoft Ignite"

---

# Preventing data exfiltration with a layered protection strategy
**Microsoft Purview DLP Improvements Overview**

1. **Layered Protection**: 
   - Data is protected at three stages: at rest, in transit, and in use. This multi-layer approach ensures comprehensive security without gaps.

2. **Expanded File Type Protection**:
   - Beyond traditional Office and PDF files, Purview now protects various document formats, enhancing coverage for diverse organizational needs.

3. **Inline Data Protections for Web Traffic**:
   - Real-time monitoring of web interactions and third-party cloud app usage to prevent data leaks, whether through browsers or external apps.

4. **Endpoint DLP Enhancements**:
   - Advanced protection against exfiltration from devices, using AI to detect and block unusual activity, ensuring sensitive data remains secure even when accessed outside the network.

5. **AI-Driven Data Security Triage**:
   - An AI tool categorizes security alerts into high, medium, or low risk. It provides context for each alert and can notify relevant personnel, aiding in swift response and remediation.

6. **Ecosystem Integration**:
   - Protection extends to various data types, including structured data in databases and AI tools like Microsoft 365 Copilot, ensuring comprehensive coverage across the organization's systems.

7. **Industry-Specific Compliance**:
   - Adaptable to different industries' compliance needs, offering tailored policies for sectors like healthcare or finance, which have distinct regulatory requirements.

8. **Incident Management Integration**:
   - The triage agent likely feeds alerts into existing incident management systems, ensuring seamless workflow and quick action on critical issues.

9. **AI and Machine Learning**:
   - Utilizes AI models to detect sensitive data and block exfiltration, with pattern recognition technology adapting to organizational policies for effective protection.

This structured approach ensures that Microsoft Purview addresses a wide range of data security needs, from real-time monitoring to intelligent alert handling, providing robust protection against data breaches.
