﻿---
session_code: "BRK224"
title: "Microsoft Fabric: The data platform for the next AI frontier"
date: "2025-11-18"
speakers:
  - "Amir Netz"

products:
  - "Microsoft Ignite"

---

# Microsoft Fabric: The data platform for the next AI frontier
**Fabric IQ and AI Agents: A Comprehensive Overview**

1. **Introduction to Fabric IQ:**
   - Fabric IQ is an intelligent layer built on top of a semantic model, enhancing the user experience for Power BI users by transforming raw data into understandable formats.

2. **Semantic Model:**
   - Acts as a bridge between raw data and meaningful insights, making it easier for different data sources to interact effectively within Power BI.

3. **Fabric IQ's Capabilities:**
   - Enhances data with real-time inputs such as wind speed, weather conditions, and runway statuses, providing comprehensive context for better decision-making.

4. **AI Agents:**
   - **Power BI Chat:** Integrated into Power BI, allowing natural interaction between users and their data.
   - **Fabric Data Agent:** Enables customization for domain-specific expertise, such as finance or healthcare, with tailored analysis.
   - **Fabric Operations Agent:** Acts as a virtual team member, monitoring real-time feeds to ensure smooth operations.

5. **Integration and Scalability:**
   - Fabric IQ integrates seamlessly with existing Power BI environments, built upon semantic models. Its design supports scalability, handling complex datasets and real-time interactions effectively.

6. **Potential Applications Across Industries:**
   - Healthcare for patient data insights, finance for trend prediction and fraud detection, and more, highlighting its versatility.

7. **Considerations:**
   - Integration ease with existing systems.
   - Scalability concerns for large datasets.
   - Security and governance aspects not explicitly covered in the presentation.

8. **Conclusion:**
   - Fabric IQ represents a significant advancement in data analytics, bridging raw data to meaningful insights through intelligent layers and AI agents, enhancing efficiency and accessibility across various industries.
