﻿---
session_code: "BRK210"
title: "Train, host and infer reasoning models on Microsoft Foundry"
date: "2025-11-18"
speakers:
  - "Vijay Aski"
  - "Vijay Aski"
  - "Chris Lauren"
  - "Ankit Parag Shah"
  - "Wei Wei"

products:
  - "Microsoft Ignite"

---

# Train, host and infer reasoning models on Microsoft Foundry
<think>
Alright, after going through that detailed session on Azure Machine Learning and reinforcement learning with the Draft Model, I'm a bit overwhelmed but excited about the possibilities. Let me try to break this down.

First, the session started by explaining how Azure ML allows for creating custom models using existing open-source models like Llama 1 or others. That makes sense because it's often challenging to train large models from scratch due to computational constraints and costs. By leveraging these pre-trained models and fine-tuning them on domain-specific data, we can get models that are tailored to our needs without the heavy lifting.

Then, the concept of using reinforcement learning in Azure ML was introduced. I remember that reinforcement learning is a type of machine learning where an agent learns to make decisions by performing actions and learning from the rewards or penalties received. So, applying this to model tuning makes sense because it can optimize parameters based on some reward function. This could be really useful for tasks like hyperparameter tuning, where small adjustments can make a big difference in performance.

The notebook example walked through how to set up a custom endpoint that uses both the base and draft models. I think the key takeaway here is that by combining these two models, you're essentially creating an ensemble or a composite model. This could potentially provide better performance than using either model alone because it combines their strengths.

They also mentioned something about deploying models efficiently across different environments like on-premises and cloud, which is crucial for organizations that have data spread across various infrastructure setups. Azure ML's ability to handle this seamlessly is a big plus.

The part about optimizing efficiency through reasoning was interesting. I'm guessing this involves not just using the model but also incorporating logic or rules to decide when and how to apply the model. This could help in scenarios where not all inputs need to go through the full computation of the model, saving resources.

The conclusion emphasized the importance of maximizing ROI by improving both quality and efficiency. It makes sense because if a model is both better performing and more efficient, it's more valuable for real-world applications. Plus, using existing models can reduce costs associated with training from scratch.

I'm still a bit fuzzy on how exactly the reinforcement learning part works within Azure ML. I think I need to look into the implementation details and see how the RL component is integrated into the model. Maybe there are pre-built components or SDKs that handle the RL aspects, making it easier for someone without deep expertise in RL.

Also, the mention of fine-tuning and using tools like AutoML is something I should explore further. How does AutoML decide when to fine-tune a model versus just using the base? Is there an automatic trigger based on performance metrics or some other criteria?

Another point that stood out was the hybrid deployment approach across AKS clusters. I'm familiar with Kubernetes, so integrating ML models into existing containerized environments could be really powerful. It would allow for scalability and resource management that's already set up in those environments.

I'm curious about how the model quality improvement works in practice. Does it involve continuous monitoring of performance, or are there specific metrics used to determine when fine-tuning is needed? And how does this process integrate with other parts of the data pipeline?

The mention of custom endpoints and APIs is also something I want to delve into more. How flexible are these endpoints? Can they be easily integrated with existing applications without significant changes?

Lastly, the session mentioned that all the examples and code are available on GitHub. I should definitely check out those repositories to see how everything is structured and implemented.

Overall, while there's a lot to unpack, the main takeaways for me are:
1. Leverage existing models for cost-effective solutions.
2. Use reinforcement learning to optimize model performance.
3. Combine models (ensemble) for improved results.
4. Efficiently deploy across various environments using Azure ML.
5. Maximize ROI by enhancing both quality and efficiency.

I think the next steps would be to look at the GitHub examples, set up an Azure ML environment, and experiment with integrating these concepts into a project. Maybe start with a simple model and see how fine-tuning affects its performance. Then, explore adding reinforcement learning aspects to optimize some parameters automatically.
```
