﻿---
session_code: "BRK199"
title: "From cloud to edge: Building and shipping Edge AI apps with Microsoft Foundry"
date: "2025-11-20"
speakers:
  - "Lior Kamrat"
  - "Sam Kemp"
  - "Gautham Krishnamurthy"
  - "Raji Rajagopalan"

products:
  - "Microsoft Ignite"

---

# From cloud to edge: Building and shipping Edge AI apps with Microsoft Foundry
**Foundry Local: Enabling Edge AI Deployments - Key Insights**

1. **Overview of Foundry Local**: 
   - Foundry Local is a containerized environment designed for deploying machine learning models on edge devices. It supports platforms including Windows, Mac, Android, Azure local, and Azure Arc with Kubernetes.

2. **GitHubs Configuration**:
   - GitHubs configuration enables automatic rollouts of model updates without downtime, ensuring seamless transitions between versions in production environments.

3. **Custom Model Integration**:
   - Models can be repackaged into Foundry Local containers optimized for edge devices, leveraging hardware like GPUs and CUDA libraries for efficient computation.

4. **Kubernetes and Azure Arc Integration**:
   - The system manages models within Kubernetes clusters using Azure Arc, allowing for scaling and resource management across multiple nodes.

5. **Rolling Upgrade Demonstration**:
   - A live demo showed a smooth transition from version 1 to version 2 of a model, emphasizing the importance of maintaining uptime in production.

6. **Monitoring with NVTop**:
   - Utilizing tools like NVTop for GPU monitoring ensures efficient resource utilization on edge devices.

7. **Cross-Platform Compatibility**:
   - The presenter highlighted the ability of Foundry Local to handle models across various platforms, though specific integration details and adaptability were not deeply explored.

8. **Golden Thread Reference**:
   - Further information is needed regarding the Golden Thread mentioned for GitHubs configuration in rollouts.

9. **Performance and Security Considerations**:
   - Foundry Local's optimization for GPU acceleration was noted, but questions remain about limitations and best practices for specific hardware configurations. Security aspects and data protection were not explicitly addressed.

10. **Ease of Use for Developers**:
    - The process for developers to start using Foundry Local, including SDKs or tools, would enhance understanding and adoption.

11. **Challenges and Solutions**:
    - Integration with existing enterprise infrastructures requires addressing security concerns and infrastructure management challenges.

In conclusion, Foundry Local offers a robust solution for edge AI deployments, but further details on integration, security, and developer tools are necessary to fully leverage its capabilities.
