﻿---
session_code: "BRK191"
title: "From code to real results, AI impact with Foundry Models"
date: "2025-11-20"
speakers:
  - "John Banta"
  - "Nikhil Kumar"
  - "Naomi Moneypenny"
  - "Andy O’Dower"
  - "Anand Raman"

products:
  - "Microsoft Ignite"

---

# From code to real results, AI impact with Foundry Models
**Summary: AI Model Selection and Integration with Microsoft Foundry**

The presentation explored advancements in artificial intelligence (AI) model selection and integration, particularly through Microsoft Foundry. Here are the key points:

1. **Model Optimization and Selection**: The focus was on how Microsoft's Model Router simplifies selecting the right AI model based on specific requirements such as cost, quality, or task complexity.

2. **Multimodal AI Integration**: The discussion highlighted the integration of various AI models beyond text generation, including image and video processing. This involves multimodal suites that handle tasks with varying needs for cost-effectiveness, latency, and editing capabilities.

3. **Efficient Model Use**: Using examples like GitHub Copilot, the presentation demonstrated how accessible it is to develop applications that leverage AI models without manual navigation of extensive catalogs.

4. **Complex Task Handling**: For complex prompts requiring structural composition and diagrams, the Model Router adapts by selecting appropriate models that balance photorealism and semantic understanding.

5. **Shift in AI Focus**: The emphasis shifted from model selection to outcome and intent, reflecting a broader trend in AI where the focus is on achieving desired results rather than specific model usage.

6. **Developer Tools and Resources**: The event encouraged attendees to utilize Microsoft Foundry's integrated developer experience (IDE), SDK, and community resources for building applications and exploring AI capabilities.

**Conclusion**: The presentation highlighted how Microsoft Foundry streamlines AI model selection, enabling efficient and effective use of AI across various applications. This is particularly beneficial for developers looking to integrate advanced AI features into their projects seamlessly.
