﻿---
session_code: "BRK187"
title: "AI Playbook for ROI with Microsoft Foundry"
date: "2025-11-19"
speakers:
  - "Marco Casalaina"
  - "Mike Gozzo"
  - "Nikhil Kumar"
  - "Rakhee Langer"
  - "Sethu Raman"
  - "Ian Wells"

products:
  - "Microsoft Ignite"

---

# AI Playbook for ROI with Microsoft Foundry
The demo presented by Ian Wells highlights real-time cost tracking features in the AI platform, allowing developers to monitor expenses on both model and agent sides. Here's a breakdown of the key points:

1. **Real-Time Cost Tracking**: Developers can input queries or code snippets into the system, which then calculates estimated costs as they type, displayed on the traces tab.

2. **Model and Agent Costs**: The platform tracks costs for both models and agents, providing immediate feedback to help optimize resource usage.

3. **Functionality**:
   - **Traces Tab**: Displays real-time cost estimates as developers interact with the system.
   - **Querying**: Asks questions or inputs code snippets to trigger cost calculations.

4. **Implementation Details**:
   - **Calculation Methodology**: Likely uses dynamic pricing based on usage patterns, possibly including operational costs like computing resources.
   - **Rate Limits**: May have limits to prevent abuse, affecting how often developers can query costs.

5. **Accuracy and Use Cases**: While the estimates are real-time, their accuracy compared to production costs is important for budgeting. This tool seems useful for managing expenses during AI development and deployment phases.

6. **Additional Features**:
   - **Exportability**: Potentially allows data export for further analysis or billing.
   - **User Interface**: User-friendly interface that integrates with existing workflows, enhancing transparency and control over costs.

In summary, this feature aims to empower developers with insights into their AI model expenses, helping them make informed decisions without overspending.
