﻿---
session_code: "BRK183"
title: "Azure Arc: Extending Azure for hybrid and multi-cloud management"
date: "2025-11-19"
speakers:
  - "Brendan Burns"
  - "Steven Bucher"

products:
  - "Microsoft Ignite"

---

# Azure Arc: Extending Azure for hybrid and multi-cloud management
**Azure Arc: A Comprehensive Overview from Microsoft Ignite**

At Microsoft Ignite, the focus was on Azure Arc, a platform designed to manage servers across hybrid and multi-cloud environments. Here's a structured summary of key points discussed:

1. **Hybrid and Multi-Cloud Management**: Azure Arc offers unified management capabilities for servers located in various cloud environments, including on-premises, Azure, AWS, and Google Cloud.

2. **New Features**:
   - **Auto-Upgrade for Agents**: Ensures the latest patches are applied to the Azure Arc agent, enhancing security.
   - **Machine Configuration Policies**: Allows users to set customizable baseline policies for consistent server configurations.
   - **WinRE+Arc**: Enables integrated recovery without needing a USB stick, ideal for environments with limited physical access.
   - **Workload Identity**: Facilitates resource access using an identity separate from the user's own system, enhancing flexibility in hybrid setups.
   - **Offline Secrets Management**: Allows access to secrets without requiring an online cluster, boosting security and operational efficiency.

3. **GitOps Integration**: Azure Arc supports Argo and Flux for declarative infrastructure management, enabling infrastructure as code practices.

4. **Staying Updated**: The Azure Arc monthly meetup and a comprehensive blog provide resources for users to keep abreast of new features and best practices.

5. **Use Cases**: Particularly beneficial in critical environments like hospitals or airports where physical access is challenging.

**Conclusion**: Azure Arc aims to be a centralized, robust management layer that simplifies hybrid and multi-cloud operations with enhanced security and automation, appealing to organizations seeking modernized IT infrastructure solutions.
