﻿---
session_code: "BRK180"
title: "Inference at record speed with Azure ND Virtual Machines"
date: "2025-11-20"
speakers:
  - "Hugo Affaticati"
  - "Nitin Nagarkatte"

products:
  - "Microsoft Ignite"

---

# Inference at record speed with Azure ND Virtual Machines
**Azure Infrastructure Overview: Enabling Scalable and High-Performance AI Solutions**

Azure's infrastructure is designed to support the scale and performance demands of AI and machine learning workloads, positioning it as a leader in providing robust solutions for the next generation of AI applications. Here's a structured breakdown:

1. **VM Series Optimization**:
   - **NC Series**: Optimized for AI and machine learning tasks, featuring a high number of GPUs suitable for model training.
   - **ND Series**: Designed for large-scale models, offering configurations that cater to complex computational needs.

2. **High-Performance Computing (HPC) Clusters**:
   - Azure's HPC clusters enable the creation of scalable, distributed computing environments crucial for tasks like model training, leveraging bare-metal VMs and virtual machines for efficient resource utilization.

3. **Storage Solutions**:
   - **Premium Blob Storage**: Offers significant performance improvements with low latencies (10x improvement on average, 40x at the 99th percentile), ensuring quick data access essential for AI applications.
   - **Azure Container Storage for Models**: Utilizes fast local NVMe SSD storage to enhance model loading speed, reducing latency by leveraging direct storage attached to compute nodes.

4. **Global Infrastructure**:
   - Azure's extensive global footprint with 70 regions and 200 data centers ensures low latency worldwide through advanced fiber-optic networks, crucial for distributed AI workloads.

5. **Partnerships and Technology Integration**:
   - Collaboration with Nvidia provides access to their Blackwell GPUs, specialized hardware that accelerates AI tasks, enhancing Azure's capability in handling complex computational demands.

6. **Exascale Supercomputing**:
   - Azure's infrastructure supports exascale computing, capable of performing 10^18 operations per second, essential for training large models without performance bottlenecks.

In conclusion, Azure is committed to building an infrastructure that scales with AI needs, emphasizing high-performance storage, global reach, and partnerships to support the development and execution of cutting-edge AI applications. This strategic approach underscores Azure's role in advancing responsible and impactful AI solutions.
