﻿---
session_code: "BRK1745"
title: "Scaling the Agentic Web with NLWeb"
date: "2025-11-20"
speakers:
  - "Chelsea Carter"
  - "Ramanathan Guha"

products:
  - "Microsoft Ignite"

---

# Scaling the Agentic Web with NLWeb
**NL Web: An Overview and Reflection**

NL Web is a transformative concept that overlays multiple AI services, creating a unified interface for enhanced user interactions. Here's a structured breakdown of its key aspects:

1. **Common Interface (Ask):**
   - NL Web runs on technologies like MCP and A2A, providing a standardized "Ask" tool.
   - This interface aggregates responses from various AI systems, ensuring consistent and accurate answers.

2. **Implementations and Customization:**
   - Each implementation (e.g., MCP, Elastic) uses its own language models, each with unique strengths.
     - For instance, MCP emphasizes accuracy to prevent hallucinations, crucial for commercial applications like product promotion.

3. **Generative AI Integration:**
   - The challenge lies in ensuring generative AI systems recognize and reference specific products accurately.
   - Partnerships with platforms like Copilot aim to integrate generative AI into responses, allowing dynamic content generation.

4. **Ecosystem and Contributions:**
   - NL Web's ecosystem supports multiple services, each contributing their perspective without conflicting user experiences.
   - It acts as a hub where various AI systems can collaborate, enhancing the overall user experience through diverse yet coherent answers.

5. **User Experience Considerations:**
   - The seamless integration of multiple AI services must balance personalization with consistency.
   - Future scalability is crucial to handle increasing data loads and user interactions efficiently.

6. **Technical Aspects and Implementation:**
   - It likely uses a plugin system where each service adds unique features, adhering to standard APIs for compatibility and functionality.

7. **Call to Action and Next Steps:**
   - Users are encouraged to explore resources and engage with providers for deeper insights and implementation strategies.

In essence, NL Web is a collaborative framework that harnesses the power of distributed AI systems, ensuring relevant and accurate information delivery while fostering an ecosystem where each participant thrives.
