﻿---
session_code: "BRK1739"
title: "How Fabric Data Agents Are Powering the Next Wave of AI"
date: "2025-11-21"
speakers:
  - "Shreyas Canchi Radhakrishna"
  - "Amir Jafari"

products:
  - "Microsoft Ignite"

---

# How Fabric Data Agents Are Powering the Next Wave of AI
**Answer:**

Data Agents can effectively handle unstructured data even without semantic models or ontologies by leveraging embeddings and other techniques. Here's a structured overview of how this works:

1. **Embeddings for Unstructured Data**: 
   - Unstructured data, such as text, can be converted into numerical vectors called embeddings. These embeddings capture the meaning and context of the data, allowing for semantic understanding without relying on explicit semantic models or ontologies.

2. **Integration with Data Agents**:
   - Data Agents can consume unstructured data along with structured data sources. This integration allows them to reason across both types of data, utilizing embeddings to bridge the gap between structured and unstructured information.

3. **Building Multiple Agents**:
   - Each Data Agent can be specialized for a specific domain or topic. For example, an agent focused on sales can handle both structured sales data and unstructured text related to market trends or customer feedback.

4. **Consumption and Sharing**:
   - Data Agents can be shared and consumed by other users or systems. They are designed to be accessible wherever needed, whether within a specific application or as part of a larger ecosystem.

5. **Use Cases and Implementation**:
   - Embeddings can be generated using pre-trained models or custom training on domain-specific data. This allows Data Agents to handle various unstructured data types effectively.
   - Data Agents can pull data from lakehouses or other data sources, combining it with embeddings for enhanced reasoning.

6. **Future Considerations**:
   - The team is working on making these functionalities more accessible and robust, ensuring they meet scalability and security requirements.

In summary, Data Agents provide a flexible solution for managing both structured and unstructured data, enabling intelligent reasoning without the need for explicit semantic models through techniques like embeddings.
