﻿---
session_code: "BRK173"
title: "Azure IaaS best practices to enhance performance and scale"
date: "2025-11-21"
speakers:
  - "Yi Chai"
  - "Varun Shandilya"
  - "Amit Srivastava"

products:
  - "Microsoft Ignite"

---

# Azure IaaS best practices to enhance performance and scale
The presentation focused on enhancing the performance and reliability of applications in high-performance computing environments using Azure. Here are the key points:

1. **Bursting Capacity Optimization**: Utilizing multiple VMs spread across regions to handle load spikes efficiently without over-provisioning resources unnecessarily.

2. **Storage Solutions**: 
   - **Local SSDs and Premium SSDs**: Using these for I/O-intensive tasks and critical workloads like databases, leveraging their faster processing capabilities.
   - **Azure Disks and UltraDisk**: Highlighted the importance of Azure Disks for data persistence and introduced UltraDisk as a high-performance block storage solution supporting up to 800,000 IOPS and 14 Gbps.

3. **Instant Access Snapshots**: Revolutionizes snapshot creation by eliminating waiting times through immediate access via a pointer, allowing quick disk creation for backups or cloning without performance impact.

4. **Failure Handling**: Azure's native prevention of "turn rights" ensures data integrity during power failures, using hardware-based solutions to avoid software overhead and potential data loss.

5. **Performance Boost**: Disabling traditional write prevention in Linux (using LVM or ext4) reduces OS overhead, boosting performance by up to 47% latency reduction and doubling throughput.

In summary, the presentation emphasized leveraging Azure's advanced storage features to optimize workloads for high performance, low latency, efficient failure handling, and improved operational efficiency.
