﻿---
session_code: "BRK1704"
title: "Innovation Session: Scale Smarter: Infrastructure for the Agentic Era"
date: "2025-11-19"
speakers:
  - "Nidhi Chappell"
  - "Annie Pearl"
  - "Jeremy Winter"

products:
  - "Microsoft Ignite"

---

# Innovation Session: Scale Smarter: Infrastructure for the Agentic Era
**Summary: Azure Copilot Migration Overview**

Azure Copilot Migration is an innovative AI-driven tool designed to facilitate the migration of applications from on-premises environments, such as VMware, to Microsoft Azure. Here's a structured overview of its key features and implications:

1. **Functionality and Workflow Integration:**
   - The tool operates through connected agentic workflows, enabling collaboration between IT teams managing cloud environments and developers working within GitHub Copilot.
   - It automates tasks that were once manual, such as resource assessment, ROI analysis, landing zone setup, and code modernization.

2. **Example Use Case (Zawa):**
   - Demonstrated through a roleplay scenario, the tool assists in:
     - Identifying resources and dependencies.
     - Calculating migration ROI.
     - Recommending a PaaS-based approach for application migration.
     - Setting up secure Azure landing zones.
     - Conducting code assessments and modernization using GitHub Copilot.

3. **AI and Integration Insights:**
   - The AI component likely utilizes existing tools and data, enhancing speed and accuracy in providing recommendations.
   - Integration with GitHub Copilot allows developers to directly access insights and push changes into repositories, fostering collaboration.

4. **Handling Different Scenarios:**
   - While the tool suggests a PaaS approach, it may not be suitable for all applications. Potential fallbacks or additional steps might be necessary, depending on application complexity and custom code requirements.

5. **Security and Compliance:**
   - The agent facilitates secure landing zones by managing network policies, identity management, and access control. This ensures configurations are optimized without manual intervention.

6. **Challenges and Considerations:**
   - **Custom Code:** Handling complex or custom code that resists containerization may require additional steps.
   - **Scalability:** The tool's effectiveness for large, complex environments is a consideration.
   - **Real-World Impact:** Case studies would highlight outcomes like cost reduction and performance improvements.

7. **Market Positioning:**
   - As part of Azure's broader strategy for cloud-native solutions, the tool could be a significant enabler for digital transformation.
   - Comparisons with other tools may highlight unique features such as AI integration and comprehensive workload support.

**Conclusion:**
Azure Copilot Migration represents a transformative approach to application migration, offering streamlined, collaborative, and automated processes. While it addresses several pain points in traditional migration methods, further exploration is needed for handling complex applications and ensuring robust security.
