﻿---
session_code: "BRK1700"
title: "Innovation Session: Windows & Microsoft 365 Copilot: Secure AI & agent productivity"
date: "2025-11-19"
speakers:
  - "Pavan Davuluri"
  - "Navjot Virk"
  - "Jason Gowans"
  - "Stefan Kinnestrand"

products:
  - "Microsoft Ignite"

---

# Innovation Session: Windows & Microsoft 365 Copilot: Secure AI & agent productivity
<think>
Okay, so I just finished watching this talk by Jason Gawker from Levi's at Microsoft Ignite. Let me try to process what he said and see how it applies to my own work or situation. 

He started talking about how Levi's is using AI and agents to automate tasks within their company. Initially, they focused on IT services, which made sense because any company would want to streamline those processes. The results were clear: faster resolution times and higher satisfaction. That makes me think that any departmental automation should start with IT because it’s a low-hanging fruit and sets the precedent for success.

Then he mentioned moving on to HR, legal, investor relations, etc. So once they saw the IT services worked well, they had the confidence to expand the use of AI throughout other areas. That’s smart because it prevents silos of automation and makes the solution more robust across the company. It also probably improves collaboration between departments since everyone is using similar tools.

He talked about building a unified intelligence layer across the entire company. That sounds like integrating data from various sources to make better decisions. I can see how that would help in areas like finance or operations where having a holistic view is crucial. It's not just about automating tasks but also enhancing decision-making capabilities, which is a big win.

The mention of using GitHub Copilot for code generation is interesting because it shows how AI isn't limited to internal processes but can enhance developer productivity as well. 40% of their code being AI-generated suggests that they've seen significant efficiency gains. This makes me think about how AI can not only handle repetitive tasks but also assist in creative problem-solving, which developers often do.

He ended with some key takeaways for a Frontier firm: focusing on strategy before tools, emphasizing people over technology, prototyping fast and scaling what works, treating everything as learning, designing adaptable platforms, and staying true to the brand while evolving. That’s a solid set of principles because it's easy to get swept up in the latest tech without knowing if it actually addresses your problems.

One point that stood out was the idea of starting with clear problem-solving. It's easy to get excited about AI but forget why you're implementing it in the first place. Without a clear focus, you might end up with technology that doesn't add value. So for my own work, I should make sure any AI initiative is grounded in solving specific problems rather than just because it's cool.

Another important point was treating everything as learning. Since AI and agents are still evolving, being able to adapt and change based on feedback and results is crucial. This means having the flexibility to pivot strategies if something isn't working, which requires a culture that embraces continuous improvement.

Designing an adaptable platform was also key. With rapid changes in technology, the systems need to be flexible enough to accommodate new tools without disrupting existing workflows. This probably involves modular design where different components can be updated or replaced without affecting the whole system.

Lastly, staying true to the brand while evolving is important because you don't want to lose sight of your core values as you adopt new technologies. It's about maintaining integrity and relevance in a changing world.

In summary, Levi's approach to AI and automation seems strategic and people-focused. They started small, expanded success, integrated across departments, focused on solving problems, and built an adaptable system all while keeping their brand identity intact. This gives me some actionable insights: start with clear problem-solving, emphasize the role of people, prototype and iterate quickly, treat everything as a learning opportunity, design for adaptability, and stay true to your values.
```
