﻿---
session_code: "BRK168"
title: "Azure IaaS platform security deep dive"
date: "2025-11-21"
speakers:
  - "Vikas Bhatia"
  - "Mario Lopez"

products:
  - "Microsoft Ignite"

---

# Azure IaaS platform security deep dive
**Azure Network Security: A Comprehensive Overview**

1. **Introduction to Azure Network Security**
   - The importance of securing networks in today's connected world was emphasized, with a focus on proactive measures against potential threats.

2. **Azure Firewall as a Key Component**
   - Azure Firewall is highlighted as a managed service offering both basic and premium options.
   - Basic version includes DOS protection, while the premium version adds advanced threat detection and URL filtering.

3. **Shared Responsibility Model**
   - Both Azure and the customer share responsibility for security. The user must ensure secure configurations despite relying on Azure's tools.

4. **Network Monitoring and Visibility Tools**
   - Azure Monitor for VMs provides insights into VM health and potential breaches.
   - Azure Network Analytics offers detailed traffic analysis, aiding in threat detection and issue resolution.
   - Azure Purple Turtle, an open-source solution, integrates with Azure for advanced network monitoring.

5. **Traffic Management**
   - Azure Traffic Manager distributes traffic across regions or data centers, enhancing redundancy and efficiency.

6. **Secure Connectivity Solutions**
   - Azure VPNs and Azure ExpressRoute provide secure remote office connections and high-speed links respectively.

7. **Workload Protection**
   - Azure Bastion enables RDP/SSH access without exposing compute workloads.
   - Azure Security Gateway controls outbound traffic, preventing unauthorized data exfiltration.

8. **API and Web Server Security**
   - App Gateway manages inbound traffic with threat detection and filtering features, protecting backend systems from attacks.

9. **DOS Protection**
   - Azure's managed solution automatically offloads DOS attacks, preventing server overload.

10. **Egress Staging with Firewall**
    - Controls outbound traffic to trusted destinations, mitigating insider threats.

11. **Best Practices**
    - Regular monitoring, patching, and user training are foundational security measures for a robust posture.

12. **Integration and DevOps Considerations**
    - Tools like Azure Monitor and Network Analytics provide unified network visibility.
    - Exploring how Azure Bastion handles authentication is crucial for effective use.

13. **Conclusion**
    - Azure offers comprehensive network security tools that, when integrated, enhance overall security posture.

In summary, Azure provides a robust suite of tools to secure networks effectively, requiring careful integration and understanding to maximize their potential in enhancing security.
