﻿---
session_code: "BRK165"
title: "Migration lessons from Microsoft Federal's RISE with SAP deployment"
date: "2025-11-21"
speakers:
  - "Barbara McElnea"
  - "Veronika Reger"
  - "Greg Simons"

products:
  - "Microsoft Ignite"

---

# Migration lessons from Microsoft Federal's RISE with SAP deployment
The RISE journey presented by Microsoft Federal and NS2 encompasses a significant transformation aimed at modernizing their IT infrastructure while emphasizing security and efficiency. Here's a structured summary of their journey:

1. **Challenge Coin Tradition**: A symbolic commemoration of their partnership, reflecting the significance of their collaboration and achievements.

2. **Security-First Approach**: Prioritizing security throughout their systems, utilizing tools like Active Directory (AAD) for identity management and enhancing security measures as they transitioned to cloud environments.

3. **Modernization of Systems**:
   - Decommissioning legacy systems like OpenText and integrating real-time data solutions to improve processing speeds and decision-making capabilities.
   - Transitioning from file-based systems to cloud-optimized data storage, using Azure Blob for efficient data management.

4. **Tools and Integrations**:
   - Implementing Vert.Ex for transaction handling, choosing on-premises deployment for security reasons and using V-Net for secure communication with Rise.
   - Utilizing Hannah replicate for disaster recovery, replicating data across Azure regions to ensure business continuity.

5. **Legacy System Integration**: Maintaining a 30-year-old granddaddy system for critical functions like export documentation and sales processes, integrating it into the new RISE platform for streamlined operations.

6. **Continuous Security Evolution**: Adopting proactive cybersecurity measures to address evolving threats, ensuring data protection and compliance in federal environments.

7. **Data Management Enhancements**:
   - Shifting from static to real-time data processing, improving analytics capabilities.
   - Embedding Indexing and Layout Modification (ILM) within Azure blob storage for enhanced data accessibility and searchability.

Overall, the journey highlights Microsoft Federal and NS2's commitment to modernization, scalability, and security, positioning them for enhanced operational efficiency and compliance in a federal setting.
