﻿---
session_code: "BRK141"
title: "Tools and best practices for migrating VMware environments to Azure"
date: "2025-11-19"
speakers:
  - "Vikram Bansal"
  - "Jeff Woolsey"

products:
  - "Microsoft Ignite"

---

# Tools and best practices for migrating VMware environments to Azure
**Modernizing VMware Environments with Azure: A Strategic Overview**

1. **Understanding Key Migration Strategies**
   - **Azure Virtual Machines (AVM):** A direct alternative to VMware, allowing existing VM environments to run on Azure without significant changes.
   - **Azure Kubernetes Service (AKS):** Ideal for containerized applications, offering managed Kubernetes orchestration.
   - **Azure Arc:** Facilitates management of VMs and Kubernetes across multiple cloud providers, helping extend existing investments without full migration.
   - **Windows Admin Center (WAC) Virtualization Mode:** A new feature for managing Windows Server Hyper-V environments as an appliance on Azure.

2. **Migration Strategies Explained**
   - **Rehosting:** Lift-and-shift VMware environments to Azure with minimal changes, suitable for immediate needs.
   - **Refactoring:** Modernizes application architecture, often involving containerization or microservices, for future-proof solutions.
   - **Replatforming:** Migrates workloads to platforms like AKS, optimizing for cloud-native architectures.
   - **Retirement:** Decommissioning legacy systems once migration is complete.

3. **Tools and Services for Migration**
   - **Azure Migrate:** Assists in assessing and migrating workloads to Azure.
   - **Assessment Tools:** Evaluate current environments and plan migrations effectively.
   - **Operations Manager and Backup Solutions:** Ensure ongoing management and data protection post-migration.

4. **Pilot Project Insights**
   - Migrated a large VMware environment using AVM for VMs, AKS for containers, Azure Arc for managed instances, and WAC Virtualization Mode for Hyper-V management.
   - Highlighted the importance of application needs and leveraging Azure-native services for better performance and scalability.

5. **Key Considerations and Takeaways**
   - **Application Needs:** Choose migration strategies based on whether applications are containerized or need VMs.
   - **Tools Utilization:** Use Azure tools like Migrate, Arc, and WAC to ensure efficient and consistent management across environments.
   - **Migration Process:** Requires careful planning, especially for large environments, but tools can facilitate a manageable transition.

In summary, the migration process offers multiple pathways tailored to specific needs, from quick rehosting to long-term refactoring. Leveraging Azure services ensures modernization benefits, enhancing performance and scalability while maintaining existing investments.
