﻿---
session_code: "BRK136"
title: "Unleashing SAP Databricks on Azure: Modernize, analyze, and innovate"
date: "2025-11-18"
speakers:
  - "Anavi Nahar"
  - "Shanku Niyogi"

products:
  - "Microsoft Ignite"

---

# Unleashing SAP Databricks on Azure: Modernize, analyze, and innovate
**Integrating SAP Data with Azure Data Bricks: A Comprehensive Overview**

1. **Problem Identification and Solution Overview:**
   - Organizations face challenges with SAP data due to its complexity, siloed nature, and difficulty in integration with modern tools like AI.
   - Azure Data Bricks and Genie offer a unified data platform solution, addressing these issues efficiently.

2. **Azure Data Bricks as a Serverless Compute Solution:**
   - Provides a scalable environment for big data projects without infrastructure management.
   - Supports seamless access to SAP data through Delta Sharing, avoiding traditional ETL processes.

3. **Genie: A Conversational Analytics Tool:**
   - Enables interaction with data using natural language, generating SQL queries and visualizations.
   - Demonstrates how it can quickly respond to user questions, such as cash flow analysis, without manual intervention.

4. **Integration Highlights:**
   - Direct access to SAP products within the Data Bricks environment, enhancing usability.
   - Reduces operational overhead by eliminating complex infrastructure setups.

5. **Considerations and Questions:**
   - Data governance and security are crucial; further investigation is recommended for organizations with sensitive data requirements.
   - Scalability and performance on large datasets should be assessed to ensure smooth operations.
   - Integration with other Microsoft tools like Power BI and Excel could extend functionality.

6. **Implementation Implications:**
   - Easier digital transformation through reduced integration effort, though existing systems may require planning and additional resources.

7. **Industry Applications:**
   - Applicable across various industries where SAP is utilized, offering potential in finance, operations, and beyond.

In conclusion, Azure Data Bricks and Genie provide a robust solution for leveraging SAP data effectively, enhancing analytics capabilities with minimal operational complexity.
