﻿---
session_code: "BRK135"
title: "From DEV to PROD: How to build agentic memory with Azure Cosmos DB"
date: "2025-11-20"
speakers:
  - "Derek Boudreau"
  - "Kendall Brasch"
  - "James Codella"
  - "PhD"
  - "Felipe Morales Heerlein"

products:
  - "Microsoft Ignite"

---

# From DEV to PROD: How to build agentic memory with Azure Cosmos DB
**Empowering Customers with AI: A Comprehensive Overview**

**Introduction and User-Centric Design**
The session emphasized placing customers at the core of strategic development, particularly addressing the needs of aging populations. The example of Jacqueline, an 82-year-old customer, highlighted how technology can alleviate shopping stress, underscoring the importance of user-centric design.

**Cartoolisto: An AI-Powered Shopping Assistant**
Cartoolisto is introduced as an AI-driven tool designed to enhance shopping efficiency. It transforms the time-consuming process of creating a shopping list from 18 minutes to just nine minutes for 30 items. Utilizing Azure Cosmos DB, this solution efficiently handles large datasets and real-time interactions.

**Key Features: Low Latency and Hyperpersonalization**
- **Low Latency:** Ensures fast response times, crucial for real-time applications like conversational AI.
- **Hyperpersonalization:** Adapts to individual user history and preferences, enhancing recommendation accuracy and relevance.

**Data Management with Azure Cosmos DB**
Cosmos DB's role as a scalable NoSQL database is pivotal. It supports storing metrics, location data, and enabling rapid product searches, essential for fast decision-making by users.

**Scalability and Expansion Potential**
The solution's scalability is highlighted, with Azure services enabling expansion beyond Chile to other markets. This capability is vital for accommodating growing user bases and data volumes.

**Technological Insights and Future Directions**
- **Multi-Agent Systems:** The potential integration of voice assistants and daily task management suggests broader applications beyond shopping.
- **Future Innovations:** Possibilities include managing medications, suggesting recipes, and assisting with daily tasks, leveraging advanced AI techniques like reinforcement learning and deep neural networks.
- **Security and Privacy:** Robust measures, including encryption and access control, are assumed to protect sensitive user data.

**Conclusion: A Vision for AI in Daily Life**
The session concludes by illustrating how AI can empower users, particularly the elderly, through efficient and personalized tools. The future of cartoolisto and similar technologies lies in enhancing daily life through intelligent assistance systems.
