﻿---
session_code: "BRK134"
title: "Modern data, modern apps: Innovation with Microsoft Databases"
date: "2025-11-18"
speakers:
  - "Shireesh Thota"
  - "Charles Feddersen"
  - "Kirill Gavrylyuk"
  - "Priya Sathy"
  - "Shivakumar Vaithyanathan"

products:
  - "Microsoft Ignite"

---

# Modern data, modern apps: Innovation with Microsoft Databases
**Answer:**

**Understanding Azure Cosmos DB Fleet Pools in Multi-Tenant Applications**

Azure Cosmos DB's Fleet Pools provide a strategic approach to managing multi-tenant applications by optimizing resource utilization across multiple database accounts. Here's a structured summary of the key points:

1. **Multi-Tenant Applications Context**: These are applications where a single database serves multiple tenants, each with distinct data requirements and usage patterns.

2. **Traffic Patterns and Resource Utilization**: Different tenant accounts may experience varying spikes in resource usage. By pooling these resources, you can share capacity rather than over-provisioning for peak usage across all accounts.

3. **Fleet Pools Concept**: A Fleet Pool groups multiple database accounts together, allowing them to share throughput. This shared pool reduces costs by avoiding the need for individual scaling while maintaining security and isolation for each account.

4. **Traffic Spikes Management**: During sales promotions or similar events, some accounts may spike heavily, while others may not. By pooling these, you can ensure that resource-intensive tasks are handled without over-provisioning, thus optimizing costs.

5. **Fleet Pool Configuration**:
   - **Grouping Accounts**: Similar traffic patterns (e.g., enterprise customers with predictable peaks) are grouped into a single Fleet.
   - **Throughput Allocation**: A cap is set for the pool to manage resource allocation dynamically based on demand.

6. **Monitoring and Analytics**:
   - **Fleet Analytics**: Tools like Microsoft Fabric allow tracking of performance at scale, enabling insights into usage patterns and optimization opportunities.
   - **Account Behavior Analysis**: Insights can be generated to identify underutilized accounts or areas for optimization, aiding in better resource management.

7. **Considerations and Comparisons**:
   - **Potential Downsides**: While sharing resources, one account's high demand could impact others. However, the pooling mechanism likely includes safeguards to prevent resource depletion.
   - **Comparison with Other Solutions**: Unlike serverless databases, Fleet Pools focus on shared resource management rather than automatic scaling, offering a balance between cost efficiency and control.

8. **Conclusion**: Azure Cosmos DB's Fleet Pools offer an efficient and cost-effective solution for multi-tenant applications by enabling resource sharing across similar workloads, thus optimizing both performance and costs.
