﻿---
session_code: "BRK128"
title: "Accelerate Data and AI transformation with Azure Databricks"
date: "2025-11-21"
speakers:
  - "Will Hendry"
  - "Miranda Luna"
  - "Anavi Nahar"

products:
  - "Microsoft Ignite"

---

# Accelerate Data and AI transformation with Azure Databricks
<think>
Okay, so I'm trying to understand how this Azure Data Bricks integration with Teams and Copilot works. From what I gather, the user is setting up an AI-driven bot using Azure Data Bricks and Copilot. They created a custom application in Teams that leverages this setup without any code. 

First, they added Azure Data Bricks Genie as a tool within their Azure environment. This probably means connecting it to their data storage, so it can pull from their proprietary bakery data. Then, they set up an agent in Copilot Studio by just adding the tool and configuring the query string.

They tested this setup by asking questions like what are my top 10 selling products. The answer came directly into Copilot, but also showed up in their monitoring area within Azure Data Bricks. This makes me think that all interactions with the bot update both places, which is useful for tracking and debugging purposes.

I'm a bit confused about how the fallback works. They mentioned that if Genie can't answer a question, it falls back to Teams or chat models. I guess this means there's some routing logic in place where if one model doesn't work, it moves on to another. That’s important because no AI is perfect all the time.

The key takeaway here seems to be about reducing development workload. The user didn't have to write any code; they just set up the tools and queried them. This must save a lot of time and effort compared to building everything from scratch.

But I wonder how this integrates with existing Teams apps. They mentioned using Teams channels and adding a new application, which might require admin access or specific permissions. Also, the user used Chrome for their screen share, so they can access the web app. Maybe the setup is browser-agnostic?

Another thing to consider is data privacy. Since it's proprietary bakery data, ensuring that this information is handled securely is crucial. I don't know if Azure Data Bricks handles encryption or compliance out of the box, but that would be a concern for deploying such a system.

Overall, this seems like a powerful way to quickly develop and deploy AI-driven applications without heavy investment in custom coding. It's interesting how tools like Copilot and Azure Data Bricks can abstract away the complexity, making it accessible even to those without deep technical expertise.
```
