﻿---
session_code: "BRK125"
title: "Meet the performance-enhanced next gen Azure SQL Managed Instance"
date: "2025-11-19"
speakers:
  - "Anitha Adusumilli"
  - "Aditya Badramraju"
  - "Troy Brovold"
  - "Craig Henninger"

products:
  - "Microsoft Ignite"

---

# Meet the performance-enhanced next gen Azure SQL Managed Instance
**Summary of the Azure Arc Migration Experience: Migrating SQL Server to Azure**

The video discusses the process of migrating a SQL Server database to Azure using the Azure Arc migration experience, highlighting its benefits and key steps. Here's a structured summary:

1. **Objective and Benefits**:
   - The goal is to enable users to migrate their on-premises SQL Server databases to Azure with minimal downtime, ensuring a smooth transition.
   - Azure Arc allows management of both on-premises and cloud databases as if they were in the cloud, eliminating the need for application code changes.

2. **Process Overview**:
   - **Assessment**: Use tools to assess the database environment, including current resource usage and performance metrics.
   - **Right-Sizing**: Configure a target SQL Managed Instance based on assessment results to optimize performance and cost efficiency.
   - **Distributed Availability Group (AVG)**: Set up an AVG using Azure Arc for seamless synchronization between on-premises and cloud databases.
   - **Data Migration**: Migrate data through a few clicks, leveraging the AVG for continuous replication.

3. **Free Offering**:
   - Users can benefit from a free SQL Managed Instance for the first year, facilitating trial usage without initial cost.

4. **AI Integration**:
   - Microsoft is integrating AI into SQL products to enhance automation and performance optimization, potentially aiding in tasks like predictive analytics.

5. **Events and Resources**:
   - Upcoming conferences (like SQL Con) provide opportunities for professionals to learn more about SQL advancements.
   - Documentation and resources are available for deeper exploration of the migration process and related tools.

6. **Considerations and Takeaways**:
   - The process minimizes downtime, a significant advantage for businesses planning a cloud transition.
   - Understanding the detailed steps involved in setting up an AVG is crucial for successful implementation.
   - Exploring case studies or step-by-step guides could provide deeper insights into real-world applications.

In conclusion, the Azure Arc migration experience offers a streamlined approach to transitioning databases to the cloud with minimal disruption. It's particularly useful for organizations aiming to modernize their IT infrastructure while maintaining operational efficiency.
