﻿---
session_code: "BRK112"
title: "Secure code to cloud with AI infused DevSecOps"
date: "2025-11-19"
speakers:
  - "Oz Wilder"
  - "Charlie Doubek"
  - "Marcelo Oliveira"
  - "Manuel Sanchez"

products:
  - "Microsoft Ignite"

---

# Secure code to cloud with AI infused DevSecOps
The talk by Marcelo and Manuel highlights the transformative potential of integrating AI into software development workflows, particularly in balancing speed and security. Here's a structured summary of the key points and insights:

1. **Problem Addressed**: Traditional software development often faces a trade-off between speed and security, leading to vulnerabilities and slow processes.

2. **AI-Driven Solution**: The discussed approach leverages AI to integrate security seamlessly from code to cloud environments. This involves tools like AI-driven vulnerability analysis and automated compliance enforcement.

3. **Platform Integration**: The solution integrates with platforms like GitHub and Azure, providing a unified environment that enhances development efficiency without compromising security.

4. **Automated Compliance and Security**: AI automates the enforcement of security policies, ensuring that code changes adhere to predefined standards in real-time, reducing manual intervention.

5. **Agent's Role**: The AI agent not only identifies vulnerabilities but also fixes them automatically, potentially reducing human error and speeding up remediation processes.

6. **Customer Experience**: Entity Data's experience using this platform demonstrated improved vulnerability response times and enhanced secure application delivery, highlighting the benefits of automated solutions.

7. **Global Scalability and Context Collaboration**: The AI-driven approach allows for global scalability, with security operations teams and developers collaborating through shared context to streamline processes and enhance efficiency.

8. **Base Image Vulnerability Management**: The AI's ability to identify and fix issues in underlying system components (like BusyBox) further reduces potential attack vectors, enhancing overall security posture.

9. **Future Outlook**: Marcelo emphasized that this approach resolves the traditional dilemma of speed vs. security, suggesting a future where AI is integral to the development culture, enabling both rapid innovation and robust protection.

10. **Considerations and Questions**: While the model's integration with various CI/CD pipelines is not detailed, it's assumed to support flexibility. Additionally, mechanisms for handling AI-driven changes that could break existing code (such as rollback strategies) may be facilitated through Azure and GitHub integrations.

In conclusion, this approach represents a significant leap in software development by automating security checks and remediations, allowing teams to deliver high-quality, secure applications efficiently.
