﻿---
session_code: "BRK108"
title: "Secure, compliant, and fast with GitHub"
date: "2025-11-20"
speakers:
  - "Collin McNeese"
  - "April Yoho"

products:
  - "Microsoft Ignite"

---

# Secure, compliant, and fast with GitHub
The meeting covered several key aspects of the organization's approach to securing their software development process. Here's an organized summary of the discussion:

1. **Security Practices Implementation**:
   - The team has implemented security practices such as pre-commit hooks, dependency scanning, and secret scanning to detect vulnerabilities early in the development cycle.
   - These tools help automate checks across repositories, ensuring consistent security configurations.

2. **Immutable Releases in Azure**:
   - Immutable releases are created once and cannot be altered post-deployment. This ensures integrity and trust in the release content, reducing the risk of unauthorized changes.

3. **Environment Isolation and Privilege Control**:
   - GitHub Actions are used to isolate environments, enforcing least privilege access to minimize attack surfaces.
   - Private networking is configured between GitHub Actions workflows and Azure environments for better security and performance.

4. **Custom Images for Hosted Runners**:
   - Custom images in Azure VMs provide consistent governance and management across projects, ensuring uniform configurations and minimizing vulnerabilities.

5. **Educational Resources and Best Practices**:
   - The organization leverages resources like GitHub Learning and the Copilot Trust Center to educate teams and enforce compliance with security rules.
   - Continuous feedback is encouraged to enhance their approach, indicating a commitment to improvement.

6. **Proactive Security Approach**:
   - The focus is on automating security checks, governance, and education to manage risks effectively and maintain a secure development pipeline.

7. **Integration of Tools**:
   - GitHub Copilot is integrated with Azure environments for task automation and code recommendations, enhancing both efficiency and security.

8. **Access Control and Policy Management**:
   - Security policies are applied using templates, allowing customization per project while maintaining a consistent baseline standard.

In summary, the organization has implemented a comprehensive strategy to secure their software development pipeline through automation, governance, and education, ensuring robust security practices across their projects.
