﻿---
session_code: "BRK107"
title: "Safe and scalable DevOps with AI agents on GitHub"
date: "2025-11-20"
speakers:
  - "Luke Hoban"
  - "Chris Patterson"

products:
  - "Microsoft Ignite"

---

# Safe and scalable DevOps with AI agents on GitHub
**Summary of GitHub's Coding Agents and Copilot Insights**

1. **AI Tools in Development Workflow:**
   - **Automation of Tasks:** GitHub's Coding Agents and Copilot can automate tasks such as code reviews, improving test coverage, and enhancing design constraints with tools like Figma.
   - **Contextual Intelligence:** These tools benefit from contextual information provided by developers, which is crucial for their effectiveness.

2. **Integration with External Tools:**
   - **Mirror Board Example:** Design tools like Figma can be integrated through URLs or images, allowing the AI to reference and incorporate design data into its context.
   - **Custom Context Setup:** Providing external tools' access (via API keys, etc.) is essential for effective integration.

3. **Limitations and Considerations:**
   - **Context Dependency:** The AI's effectiveness often hinges on the context provided by developers, such as project architecture documentation.
   - **Selection Biases:** Task complexity affects AI performance; trivial tasks may perform well while ambiguous ones pose challenges.

4. **Availability and Integration Options:**
   - **GitHub Enterprise Cloud:** Advanced features are currently limited to GitHub Enterprise Cloud.
   - **Visual Studio Code Integration:** Local use is possible via extensions, enhancing accessibility beyond cloud environments.

5. **Strategic Usage and Future Potential:**
   - **Repeat Usage Trend:** High repeat usage indicates efficiency gains but highlights the need for ongoing refinement of AI capabilities.
   - **Complementary Role:** These tools are best used to augment human expertise rather than replace it.

**Conclusion:**
GitHub's Coding Agents and Copilot offer significant potential for boosting productivity through automation, requiring strategic integration with external tools and tailored context setup. Their use should be complemented by human expertise to achieve optimal results.
